<?php

$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

    <?php
    /**
     * @see edgt_header_meta() - hooked with 10
     * @see edgt_user_scalable - hooked with 10
     */
    ?>
	<?php do_action('edgt_header_meta'); ?>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php extract(hudson_edge_get_header_variables()); ?>

    <?php get_template_part( 'includes/modules/edgt-preloader' ); ?>
    <?php get_template_part( 'includes/modules/edgt-sidearea' ); ?>

<div class="wrapper">
    <div class="wrapper_inner">

        <?php get_template_part( 'includes/modules/edgt-header' ); ?>
        <?php get_template_part( 'includes/modules/edgt-back-to-top' ); ?>
        <?php get_template_part( 'includes/modules/edgt-popup-menu' ); ?>
        <?php get_template_part( 'includes/modules/edgt-passepartout' ); ?>


<?php

?>

<div class="<?php echo esc_attr( apply_filters( 'hudson_edge_content_classes', 'content' ) ); ?>">

    <?php do_action( 'hudson_qode_after_content_begin' ); ?>

	<?php $hudson_edge_animation = get_post_meta($hudson_edge_id, "edgt_show-animation", true); ?>

    <div class="<?php echo esc_attr( apply_filters( 'hudson_edge_content_inner_classes', 'content_inner' ) ); ?>">
		<?php if($hudson_edge_options['page_transitions'] == "1" || $hudson_edge_options['page_transitions'] == "2" || $hudson_edge_options['page_transitions'] == "3" || $hudson_edge_options['page_transitions'] == "4" || ($hudson_edge_animation == "updown") || ($hudson_edge_animation == "fade") || ($hudson_edge_animation == "updown_fade") || ($hudson_edge_animation == "leftright")){ ?>
		<?php do_action('edgt_visual_composer_custom_shortcodce_css');?>
	<?php } ?>